<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
</head>
<body>
<?php
	$str = "Nel mezzo del cammin di nostra vita mi ritrovai per una selva oscura, ché la diritta via era smarrita.
Ahi quanto a dir qual era è cosa dura esta selva selvaggia e aspra e forte che nel pensier rinova la paura!
Tant' è amara che poco è più morte; ma per trattar del ben ch'i' vi trovai, dirò de l'altre cose ch'i' v'ho scorte.
Io non so ben ridir com' i' v'intrai, tant' era pien di sonno a quel punto che la verace via abbandonai.
Ma poi ch'i' fui al piè d'un colle giunto, là dove terminava quella valle che m'avea di paura il cor compunto,
guardai in alto e vidi le sue spalle vestite già de' raggi del pianeta che mena dritto altrui per ogne calle.
Allor fu la paura un poco queta, che nel lago del cor m'era durata la notte ch'i' passai con tanta pieta.
E come quei che con lena affannata, uscito fuor del pelago a la riva, si volge a l'acqua perigliosa e guata,
così l'animo mio, ch'ancor fuggiva, si volse a retro a rimirar lo passo che non lasciò già mai persona viva.
Poi ch'èi posato un poco il corpo lasso, ripresi via per la piaggia diserta, sì che 'l piè fermo sempre era 'l più basso.
Ed ecco, quasi al cominciar de l'erta, una lonza leggiera e presta molto, che di pel macolato era coverta;
e non mi si partia dinanzi al volto, anzi 'mpediva tanto il mio cammino, ch'i' fui per ritornar più volte vòlto.
Temp' era dal principio del mattino, e 'l sol montava 'n sù con quelle stelle ch'eran con lui quando l'amor divino
mosse di prima quelle cose belle; sì ch'a bene sperar m'era cagione di quella fiera a la gaetta pelle
l'ora del tempo e la dolce stagione; ma non sì che paura non mi desse la vista che m'apparve d'un leone.
Questi parea che contra me venisse con la test' alta e con rabbiosa fame, sì che parea che l'aere ne tremesse.";
	writeStringToOpaquePng("input2.png", "output2.png", $str);
	var_dump(readStringFromOpaquePng("output2.png"));
?>
</body>
</html>
<?php
/**
 * Writes an UTF-8 string in a non transparent PNG image (3 bits in each pixel)
 * @param string  $sourcePath      - the path of a png image to work with
 * @param string  $destinationPath - the path where to save the new image
 * @param string  $string          - the UTF-8 string to encode in the source image
 * @param integer $endByte         - the decimal value of the control byte used as "end of string" delimiter
 */
function writeStringToOpaquePng($sourcePath, $destinationPath, $string, $endByte = 255)
{
	// Load the base image
	$im = imagecreatefrompng($sourcePath);
	imagealphablending($im, false);
	imagesavealpha($im, false);

	// Convert the string into a byte array
	// http://php.net/manual/en/function.unpack.php#103634
	$bytes = array_slice(unpack("C*", $string), 0);

	// Append an invalid UTF-8 character to the byte array
	// http://en.wikipedia.org/wiki/UTF-8#Codepage_layout
	$bytes []= $endByte;

	// Convert the byte array into a binary string
	$binary = "";
	for($i = 0; $i < sizeof($bytes); $i++)
	{
		$binary .= str_pad(decbin($bytes[$i]), 8, 0, STR_PAD_LEFT);
	}

	// Index of the binary string's character to write
	$index = 0;

	// Loop each pixel
	for($pixel = 0; $pixel < imagesx($im) * imagesy($im); $pixel++)
	{
		// Get the pixel coordinates
		$x = $pixel % imagesx($im);
		$y = floor($pixel/imagesx($im));

		// Get the pixel color
		$colorIndex = imagecolorat($im, $x, $y);
		$colorTran  = imagecolorsforindex($im, $colorIndex);

		// Get the bits to write
		// Note: substr return false if the starting position exceed the string length
		$r = substr($binary, $index,   1);
		$g = substr($binary, $index+1, 1);
		$b = substr($binary, $index+2, 1);

		// Change the last bit of each color components
		$r = $r !== false ? floor($colorTran['red']  /2)*2 + $r : $colorTran['red'];
		$g = $g !== false ? floor($colorTran['green']/2)*2 + $g : $colorTran['green'];
		$b = $b !== false ? floor($colorTran['blue'] /2)*2 + $b : $colorTran['blue'];

		// Set the color
		$color = imagecolorallocatealpha($im, $r, $g, $b, $colorTran['alpha']);
		imagesetpixel($im, $x, $y, $color);

		$index += 3;

		// Check if we have written all the bits
		if($index >= strlen($binary))
		{
			// Write the image with the string encoded
			return imagepng($im, $destinationPath);
		}
	}

	trigger_error('Not enough transparent pixels in ' . $sourcePath, E_USER_WARNING);
	return false;
}

/**
 * Read the string encoded in an image and return it
 * @param string  $sourcePath - the path to an image with a string encoded
 * @param integer $endByte    - the decimal value of the control byte used as "end of string" delimiter
 * @return mixed
 */
function readStringFromOpaquePng($sourcePath, $endByte = 255)
{
	// Load the base image
	$im = imagecreatefrompng($sourcePath);
	imagealphablending($im, false);
	imagesavealpha($im, false);

	// Rebuild the binary string
	$binary = "";

	for($pixel = 0; $pixel < imagesx($im) * imagesy($im); $pixel++)
	{
		// Get the pixel coordinates
		$x = $pixel % imagesx($im);
		$y = floor($pixel/imagesx($im));

		// Get the pixel color
		$colorIndex = imagecolorat($im, $x, $y);
		$colorTran  = imagecolorsforindex($im, $colorIndex);

		// Add bits to the binary string
		foreach(array("red", "green", "blue") as $color)
		{
			$binary .= $colorTran[$color] % 2;

			// Check if the control byte has been found
			if(strlen($binary) % 8 == 0 && bindec(substr($binary, -8)) === $endByte)
			{
				// Rebuild the byte array
				$bytes = array();
				for($i = 0; $i < strlen($binary)-8; $i+=8)
				{
					$bytes[] = bindec(substr($binary, $i, 8));
				}

				// Convert the byte array to an UTF-8 string
				$string = call_user_func_array("pack", array_merge(array("C*"), $bytes));
				return $string;
			}
		}
	}

	return false;
}

?>