<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
</head>
<body>
<?php
	// Write message to file
	$inputFile  = "input.png";
	$outputFile = "output.png";
	$message    = '{"player": "Tenshi 天資", "score": 145300, "lives": 3, "bombs": 32}';
	writeStringToPng($inputFile, $outputFile, $message);

	// Read message from the new file
	var_dump(readStringFromPng($outputFile));
?>
</body>
</html>
<?php
/**
 * Writes an UTF-8 string in a PNG image (3 bytes in each transparent pixel)
 * @param string  $sourcePath      - the path of a png image to work with
 * @param string  $destinationPath - the path where to save the new image
 * @param string  $string          - the UTF-8 string to encode in the source image
 * @param integer $endByte         - the decimal value of the control byte used as "end of string" delimiter
 */
function writeStringToPng($sourcePath, $destinationPath, $string, $endByte = 255)
{
	// Load the source image
	$im = imagecreatefrompng($sourcePath);
	imagealphablending($im, false);
	imagesavealpha($im, true);

	// Convert the string into a byte array
	// http://php.net/manual/en/function.unpack.php#103634
	$bytes = array_slice(unpack("C*", $string), 0);

	// Append an invalid UTF-8 character to our byte array
	// http://en.wikipedia.org/wiki/UTF-8#Codepage_layout
	$bytes []= $endByte;

	// Index of the byte to write
	$index = 0;

	// Loop each pixel
	for($pixel = 0; $pixel < imagesx($im) * imagesy($im); $pixel++)
	{
		// Get the pixel coordinates
		$x = $pixel % imagesx($im);
		$y = floor($pixel/imagesx($im));

		// Get the pixel color
		$colorIndex = imagecolorat($im, $x, $y);
		$colorTran  = imagecolorsforindex($im, $colorIndex);

		// Write only on transparent pixels
		if($colorTran['alpha'] == 127)
		{
			$r = $bytes[$index];
			$g = isset($bytes[$index+1]) ? $bytes[$index+1] : 0;
			$b = isset($bytes[$index+2]) ? $bytes[$index+2] : 0;

			$color = imagecolorallocatealpha($im, $r, $g, $b, $colorTran['alpha']);
			imagesetpixel($im, $x, $y, $color);

			$index += 3;

			// Check if we have written all the bytes
			if($index >= sizeof($bytes))
			{
				// Write the image with the string encoded
				return imagepng($im, $destinationPath);
			}
		}
	}

	trigger_error('Not enough transparent pixels in ' . $sourcePath, E_USER_WARNING);
	return false;
}

/**
 * Read the string encoded in an image and return it
 * @param string  $sourcePath - the path to an image with a string encoded
 * @param integer $endByte    - the decimal value of the control byte used as "end of string" delimiter
 * @return mixed
 */
function readStringFromPng($sourcePath, $endByte = 255)
{
	$im = imagecreatefrompng($sourcePath);
	imagealphablending($im, false);

	$bytes = array();

	for($pixel = 0; $pixel < imagesx($im) * imagesy($im); $pixel++)
	{
		// Get the pixel coordinates
		$x = $pixel % imagesx($im);
		$y = floor($pixel/imagesx($im));

		// Get the pixel color
		$colorIndex = imagecolorat($im, $x, $y);
		$colorTran  = imagecolorsforindex($im, $colorIndex);

		// If transparent add the color values in our byte array until the control character is found
		if($colorTran['alpha'] == 127)
		{
			foreach(array('red', 'green', 'blue') as $color)
			{
				if($colorTran[$color] != $endByte)
				{
					$bytes []= $colorTran[$color];
				}
				else
				{
					// Convert the byte array to an UTF-8 string
					$string = call_user_func_array("pack", array_merge(array("C*"), $bytes));
					return $string;
				}
			}
		}
	}

	return false;
}
?>